;WHEN EVALUATE THIS
(defmeth (send *selector* :fake-overlay) :do-click (x y m1 m2)
(print "FAKE-OVERLAY DO-CLICK")
(call-next-method x y m1 m2))

;Then the next (from nameovrl.lsp) is evaluated

(defmeth selector-overlay-proto :do-click (x y m1 m2)
  (let* ((graph (slot-value 'graph))
         (lefts (copy-list (send self :lefts)))
         (height 10)
         (width  10)
         (gap 2)
         (topx 10)
         ;(topy (if (send self :double) 15 3))
         (vertical (send self :vertical))
         (topy (if vertical 3 15))
         (bottom (+ topy height gap))
         (idling (select (copy-list (list (send graph :idle-on))) 0))
         (i 0)
         )
(print "NAMEOVRL.lsp DO-CLICK for selector-overlay-proto")
    (when vertical
          (setf lefts (- (send self :vertical-offset) lefts))
          (setf temp y)
          (setf y x)
          (setf x temp)
          )
    (when (< y bottom)
          (when (and *plot-menu-hot-spot* (send self :hot-spot))
                (send self :do-click-pull-down-menu x y))

          (when (send self :help)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t  i :y topy :vertical vertical)
                      (send graph :plot-help)
                      (pause 10)
                      (send self :draw-button nil i :y topy :vertical vertical)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :focus)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t  i :y topy :vertical vertical)
                      (send graph :in)
                      (pause 10)
                      (send self :draw-button nil i :y topy :vertical vertical)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :remove)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t  i :y topy :vertical vertical)
                      (send graph :out)
                      (pause 10)
                      (send self :draw-button nil  i :y topy :vertical vertical)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          
          (when (send self :cancel)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t  i :y topy :vertical vertical)
                      (send graph :undo)
                      (pause 10)
                      (send self :draw-button nil  i :y topy :vertical vertical)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          (when (send self :reset)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t  i :y topy :vertical vertical)
                      (send graph :reset)
                      (pause 10)
                      (send self :draw-button nil  i :y topy :vertical vertical)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          )))

;which in turn does namelist in out undo or reset, which are defined in namelist.lsp as

    (defmeth fake-overlay :in () (focus-on-selected-obs-vars))
    (defmeth fake-overlay :out () (remove-selected-obs-vars))
    (defmeth fake-overlay :undo () (cancel-obs-vars-selection))
    (defmeth fake-overlay :reset () (show-all-obs-vars))

;these four functions are defined in namelist.lsp as 

(defun remove-selected-obs-vars ()
  (send *obs-window* :the-function ':erase-selection)
  (send *var-window* :the-function ':erase-selection)
  )

(defun focus-on-selected-obs-vars ()
  (send *obs-window* :the-function ':focus-on-selection)
  (send *var-window* :the-function ':focus-on-selection)
  )

(defun show-all-obs-vars ()
  (send *obs-window* :the-function ':show-all-points :all t)
  (send *var-window* :the-function ':show-all-points :all t)
  (send *var-window* :set-menus 0)
  )

(defun cancel-obs-vars-selection ()
  (send *obs-window* :the-function ':unselect-all-points)
  (send *var-window* :the-function ':unselect-all-points)
  (when (and (send *var-window* :all-points-showing-p) 
             (send *obs-window* :all-points-showing-p))
        (send *var-window* :set-menus 0))
  )

;all of which use the-function which is defined in namelist.lsp as


(defmeth name-list-proto :the-function (f &key all)
  (cond 
    (all (send self f))
    ((send self :any-points-selected-p) (send self f)))
  (send self :set-data-selection-states)
  )

;which gives an error if no points. so redefine as


(defmeth name-list-proto :the-function (f &key all)
  (when (> (send self :num-points) 0)
        (cond 
          (all (send self f))
          ((send self :any-points-selected-p) (send self f)))
        (send self :set-data-selection-states)
        ))